/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*******************************************************!*\
  !*** ./resources/js/admin/parts/user_settings_tab.js ***!
  \*******************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  $(document).ready(function () {
    var mapBox = $('#mapBox');
    var mapContainer = $('#mapContainer');
    var LocationLatitude = $('#LocationLatitude');
    var LocationLongitude = $('#LocationLongitude');
    var map;
    function handleMap(lat, lng, zoom) {
      mapContainer.removeClass('d-none');
      var mapOption = {
        dragging: true,
        zoomControl: true,
        scrollWheelZoom: true
      };
      map = L.map('mapBox', mapOption).setView([lat, lng], zoom);
      L.tileLayer(leafletApiPath, {
        maxZoom: 18,
        tileSize: 512,
        zoomOffset: -1,
        attribution: '© <a target="_blank" rel="nofollow" href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
      }).addTo(map);
      map.on('moveend', function (e) {
        var centerLocation = map.getCenter();
        LocationLatitude.val(centerLocation.lat);
        LocationLongitude.val(centerLocation.lng);
      });
      map.on('dragstart', function () {
        $('.region-map .marker').addClass('dragging');
      });
      map.on('dragend', function () {
        $('.region-map .marker').removeClass('dragging');
      });
    }
    var lat = LocationLatitude.val();
    var lng = LocationLongitude.val();
    if (lat && lng) {
      var zoom = mapBox.attr('data-zoom');
      handleMap(lat, lng, zoom);
    } else {
      mapContainer.addClass('d-none');
    }
    function handleMapCenterAfterSelectChange($select, zoom) {
      var selectedOption = $select.find('option:checked');
      var mapCenter = selectedOption.attr('data-center');
      mapCenter = mapCenter.split(',');
      LocationLatitude.val(mapCenter[0]);
      LocationLongitude.val(mapCenter[1]);
      if (map) {
        map.setView([mapCenter[0], mapCenter[1]], zoom);
      } else {
        handleMap(mapCenter[0], mapCenter[1], zoom);
      }
    }
    $('body').on('change', 'select[name="country_id"]', function () {
      handleMapCenterAfterSelectChange($(this), 5);
      var $this = $(this);
      $this.addClass('loadingbar gray').prop('disabled', true);
      $('select[name="province_id"]').val(null).prop('disabled', true);
      $('select[name="city_id"]').val(null).prop('disabled', true);
      $('select[name="district_id"]').val(null).prop('disabled', true);
      $.get('/regions/provincesByCountry/' + $this.val(), function (result) {
        if (result && result.code === 200) {
          var selectBox = $('select[name="province_id"]');
          var html = '<option value="">' + selectProvinceLang + '</option>';
          if (result.provinces && result.provinces.length) {
            var _iterator = _createForOfIteratorHelper(result.provinces),
              _step;
            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var province = _step.value;
                html += '<option value="' + province.id + '" data-center="' + province.geo_center.join(',') + '">' + province.title + '</option>';
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }
          }
          selectBox.prop('disabled', false);
          selectBox.html(html);
          $this.removeClass('loadingbar gray').prop('disabled', false);
        }
      });
    });
    $('body').on('change', 'select[name="province_id"]', function () {
      handleMapCenterAfterSelectChange($(this), 8);
      var $this = $(this);
      $this.addClass('loadingbar gray').prop('disabled', true);
      $('select[name="city_id"]').val(null).prop('disabled', true);
      $('select[name="district_id"]').val(null).prop('disabled', true);
      $.get('/regions/citiesByProvince/' + $this.val(), function (result) {
        if (result && result.code === 200) {
          var selectBox = $('select[name="city_id"]');
          var html = '<option value="">' + selectCityLang + '</option>';
          if (result.cities && result.cities.length) {
            var _iterator2 = _createForOfIteratorHelper(result.cities),
              _step2;
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var city = _step2.value;
                html += '<option value="' + city.id + '" data-center="' + city.geo_center.join(',') + '">' + city.title + '</option>';
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
          selectBox.prop('disabled', false);
          selectBox.html(html);
          $this.removeClass('loadingbar gray').prop('disabled', false);
        }
      });
    });
    $('body').on('change', 'select[name="city_id"]', function () {
      handleMapCenterAfterSelectChange($(this), 10);
      var $this = $(this);
      $this.addClass('loadingbar gray').prop('disabled', true);
      $('select[name="district_id"]').val(null).prop('disabled', true);
      $.get('/regions/districtsByCity/' + $this.val(), function (result) {
        if (result && result.code === 200) {
          var selectBox = $('select[name="district_id"]');
          var html = '<option value="">' + selectDistrictLang + '</option>';
          if (result.districts && result.districts.length) {
            var _iterator3 = _createForOfIteratorHelper(result.districts),
              _step3;
            try {
              for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                var district = _step3.value;
                html += '<option value="' + district.id + '" data-center="' + district.geo_center.join(',') + '">' + district.title + '</option>';
              }
            } catch (err) {
              _iterator3.e(err);
            } finally {
              _iterator3.f();
            }
          }
          selectBox.prop('disabled', false);
          selectBox.html(html);
          $this.removeClass('loadingbar gray').prop('disabled', false);
        }
      });
    });
    $('body').on('change', 'select[name="district_id"]', function () {
      handleMapCenterAfterSelectChange($(this), 13);
    });
    $('body').on('change', 'input[name="group_meeting"]', function () {
      if (this.checked) {
        $('#groupMeetingAddress').removeClass('d-none');
      } else {
        $('#groupMeetingAddress').addClass('d-none');
      }
    });
  });
})(jQuery);
/******/ })()
;